(*| 21:37  6/02/1990 *)
UNIT EGAScreen;

INTERFACE

USES StdTypes,EGAVars;

{MODULE: SCREEN}

{Screen handling routines}
{========================}

VAR
  ScreenColor, ScreenBack, ScreenBlink: Integer;
  Ink, Paper : Integer;
  Wind1X,Wind1Y,Wind2X,Wind2Y: Integer;   {Coordinates for current window}
  CursorX,CursorY: Integer;     {Current cursor position}
  PosSaved: Integer;            {count for nested SavePos..RestoreWindow}

PROCEDURE CursOn;

PROCEDURE CursOff;

PROCEDURE SetWindow(X1,Y1,X2,Y2: Integer);

PROCEDURE SavePos;

PROCEDURE RestoreWindow;

PROCEDURE FullScreen;

PROCEDURE ClearScreen;

PROCEDURE SetScreen;

FUNCTION ScreenWidth: Integer;

PROCEDURE RevVid;

PROCEDURE NormVid;

PROCEDURE BlinkOn;

PROCEDURE BlinkOff;

PROCEDURE SetColor(Forground,Background : Integer);

PROCEDURE BrightVid;

PROCEDURE DimVid;

PROCEDURE InitScreen;

PROCEDURE Heading;

PROCEDURE WriteCtl(C: Char);

PROCEDURE WriteHex(N,Size: Integer);

PROCEDURE Soundbell;

IMPLEMENTATION

USES Crt,Dos,Date;

PROCEDURE CursOn;
{Turn on display cursor}
Var Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:= $0300;           {read cursor information service}
    BX:= $0000;           {video page 0}
  END;
  Intr($10,Regs);         {call service}
  WITH Regs DO BEGIN
    AX:= $0100;           {set cursor size service}
    CX:= CX AND $0FFF;    {mask out cursor disable bit}
  END;
  Intr($10,Regs);         {and perform service}
END;  {CursOn}

PROCEDURE CursOff;
{Turn off display cursor}
Var Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:= $0300;           {read cursor information service}
    BX:= $0000;           {video page 0}
  END;
  Intr($10,Regs);         {call service}
  WITH Regs DO BEGIN
    AX:= $0100;           {set cursor size service}
    CX:= CX OR $2000;     {set cursor disable bit}
  END;
  Intr($10,Regs);         {and perform service}
END;  {CursOff}

PROCEDURE SetWindow(X1,Y1,X2,Y2: Integer);
{Set up as current window X1,Y1 to X2,Y2}
BEGIN
  Wind1X:=X1;
  Wind1Y:=Y1;
  Wind2X:=X2;
  Wind2Y:=Y2;
  Window(X1,Y1,X2,Y2);
END;  {SetWindow}

PROCEDURE SavePos;
{Save current cursor position to allow temporary writing elsewhere}
BEGIN
  IF PosSaved = 0 THEN BEGIN
    {if there is a position already saved then don't save this one}
    CursorX:= WhereX;   {otherwise save X}
    CursorY:= WhereY;   {and Y}
  END;
  PosSaved:= PosSaved+1;  {increment position saved count}
  CursOff;
END;  {SavePos}

PROCEDURE RestoreWindow;
{Restore current window}
BEGIN
  IF (PosSaved=1) THEN  BEGIN
  {if we are back to the outermost RestoreWindow statment then restore screen}
    Window(Wind1X,Wind1Y,Wind2X,Wind2Y);
    GotoXY(CursorX,CursorY);
    CursOn;
  END;
  PosSaved:= PosSaved-1;    {and decrement position save count}
END;  {RestoreWindow}

PROCEDURE FullScreen;
{Set up window for full screen area:}
BEGIN
  SetWindow(1,1,80,25);
END;  {FullScreen}

PROCEDURE ClearScreen;
{Set up window for title and time area:}
BEGIN
  SavePos;
  Window(1,2,80,25);
  ClrScr;
  RestoreWindow;
END;  {ClearScreen}

PROCEDURE SetScreen;
{Sets up the screen attributes}
BEGIN
  TextColor(ScreenColor+ScreenBlink);
  TextBackground(ScreenBack);
END;  {SetScreen}

PROCEDURE SetBorder( Color: integer);
{Sets border color}
Var Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:= $0B00;           {set color palette service}
    BX:= $0000 + Color;   {and select border color}
  END;
  Intr($10,Regs);         {and perform service}
END;  {SetBorder}

FUNCTION ScreenWidth: Integer;
{Read current video mode to get current screen width:}
Var Regs: Registers;
BEGIN
  Regs.AX:= $0F00;          {service to get current video mode}
  Intr($10,Regs);         {and perform service}
  ScreenWidth:= Hi(Regs.AX);      {get screen width from returned values}
END;  {ScreenWidth}


PROCEDURE RevVid;
{Sets reverse video on}
BEGIN
  ScreenColor:= Paper;       {set forground to paper color}
  ScreenBack:= Ink;          {and background to ink}
  IF ScreenBack > 7 THEN BEGIN
     ScreenBack:= ScreenBack-8;  {only dim colors allowed for background}
     ScreenColor:= ScreenColor+8; {but make new foreground bright}
  END;
  SetScreen;
END;  {RevVid}

PROCEDURE NormVid;
{Sets normal video}
BEGIN
  ScreenColor:= Ink;         {foreground is ink}
  ScreenBack:= Paper;        {background is paper}
  SetScreen;
END;  {NormVid}

PROCEDURE BlinkOn;
{Sets blink on}
BEGIN
  ScreenBlink:= 16;
  SetScreen;
END;  {BlinkOn}

PROCEDURE BlinkOff;
{Sets blink off}
BEGIN
  ScreenBlink:= 0;
  SetScreen;
END;  {BlinkOff}

PROCEDURE SetColor(Forground,Background : Integer);
{Sets up the screen colors:}
BEGIN
  Ink:= Forground;
  Paper:= Background;
  NormVid;
END;

PROCEDURE BrightVid;
{Sets bright video level}
BEGIN
  SetColor(MainForeground,MainBackground);
  SetScreen;
END;  {BrightVid}

PROCEDURE DimVid;
{Sets dim video level}
BEGIN
  SetColor(LightGreen,MainBackground);
  SetScreen;
END;  {DimVid}


PROCEDURE InitScreen;
{Initialise screen for 80 column color text:}
VAR
  CrtMode: Byte ABSOLUTE $0040:$0049;
BEGIN
  IF CrtMode = 7 THEN
    BEGIN
      MonoCRT:=True;
      TextMode(Mono)
    END
  ELSE
    IF CrtMode = 2 THEN
      BEGIN
        MonoCRT:=True;
        TextMode(BW80);
      END
    ELSE
      BEGIN
        MonoCRT:=False;
        TextMode(C80);
      END;
  ScreenBlink:= 0;     {ensure blink set off}
  PosSaved:= 0;        {initialise position saved value}
  BrightVid;
  SetBorder(MainBackground);
  FullScreen;
  ClrScr;
  CursOn;
END;  {InitScreen}

PROCEDURE Heading;

BEGIN
  FullScreen;
  GotoXY(1,1);
  ClrEol;
  Write(ProgramTitle);
  Write(' File : ',FontFileName,',  ',BytesPerChar,' bytes/char');
END; { Heading; }

PROCEDURE WriteCtl(C: Char);

BEGIN
  IF C < ' ' THEN
    BEGIN
      RevVid;
      Write(Chr(Ord(C)+$40));
      NormVid;
    END
  ELSE Write(C);
END; { WriteCtl }

PROCEDURE WriteHex(N,Size: Integer);

Var
  I,J,K,Mask: Integer;

BEGIN
  J:=(Size-1)*4;
  Mask:=15 SHL J;
  FOR I:=1 TO Size DO
    BEGIN
      K:=(N AND Mask) SHR J;
      IF K > 9 THEN Write(Chr(K+55)) ELSE Write(K);
      Mask:=Mask SHR 4;
      J:=J-4;
    END;
  Write(' ');
END;

PROCEDURE Soundbell;

Var I:Integer;
{Give a beep to alert operator}
BEGIN
  Sound(440);
{$IFDEF REMOTE}
(*  FOR I:=1 to 2000 DO RemoteCheck;*)
{$ENDIF}
  Delay(500);
  Nosound;
END;  {Soundbell}

END.
